unit PlayList;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Spin, ExtCtrls, Grids, SongClass;

type
  TfrmSong = class(TForm)
    srgSongs: TStringGrid;
    Label1: TLabel;
    edtArtist: TLabeledEdit;
    edtSong: TLabeledEdit;
    edtAlbum: TLabeledEdit;
    Label2: TLabel;
    sedTrackNumber: TSpinEdit;
    Label3: TLabel;
    btnAdd: TButton;
    edtDuration: TLabeledEdit;
    procedure FormShow(Sender: TObject);
    procedure btnAddClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmSong: TfrmSong;

implementation
var
 mySong: TSong;
 Row : Integer=1;

{$R *.dfm}

procedure TfrmSong.btnAddClick(Sender: TObject);
var
 Artist: String;
 Song: String;
 Album: String;
 TrackNumber: Integer;
 Duration: Integer;
begin
 Artist:= edtArtist.Text;
 Song:= edtSong.Text;
 Album:= edtAlbum.Text;
 TrackNumber:= sedTrackNumber.Value;
 Duration:= StrToInt(edtDuration.Text);
 mySong := TSong.create(Artist,Song,Album,TrackNumber,Duration);
 srgSongs.Cells[0,Row] := mySong.getQuickReference;
 srgSongs.Cells[1,Row] := mySong.getMinuteDuration;
end;

procedure TfrmSong.FormShow(Sender: TObject);
begin
  srgSongs.Cells[0,0] := 'Song: Quick reference';
  srgSongs.Cells[1,0] := 'Duration (mm:ss)';
end;

end.
